#ifdef GL_ES
attribute vec3 inVertex;
attribute vec3 inNormal;
attribute vec2 inTexCoord0;

varying float specular;
varying float diffuse;
varying float location;
varying vec2 vTexCoord;
#else
in vec3 inVertex;
in vec3 inNormal;
in vec2 inTexCoord0;

out float specular;
out float diffuse;
out float location;
out vec2 vTexCoord;
#endif
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform vec3 lightSource1;
uniform vec3 lightSource1HV;
uniform vec3 lightSource2;
uniform vec3 lightSource2HV;

uniform float brightness;
uniform float position;

void main()
{
    vec3 hV = normalize(lightSource1HV + lightSource2HV);

	float lambert = (max(0.0, dot(inNormal, lightSource1))
		+ max(0.0, dot(inNormal, lightSource2)));
	
	specular = pow(max(0.0, dot(inNormal, hV)), 8.0) * 0.35;
	diffuse = lambert * (0.75 * 0.75) * brightness;

	location = inVertex.y + position;

	vTexCoord = inTexCoord0;
	gl_Position = projectionMatrix * modelViewMatrix * vec4(inVertex, 1.0);
}
